// tablet_import.dcl
// Copyright (C) 1998 Visio Corporation.  All Rights Reserved.
//
// By Ronald Prepchuk

tablet_import : dialog {
label = "Tablet Menu Import";
initial_focus = "filename_b";
: row {
  : column {
    : row {
      : edit_box {
        key = "filename_e";
        label = "Filename: ";
        edit_width = 30;
        width = 30;
      }
      : button {
        key = "filename_b";
        label = "Browse ...";
      }
    }//end row
    : text_part {
      key = "status";
    }    
    : text_part {
      key = "error";
    }
    : row {
      : column {
        width = 6;
        : text {
          value = "Area";
        }      
        : text {
          value = "Tablet 1";
        }
        : text {
          value = "Tablet 2";
        }
        : text {
          value = "Tablet 3";
        }
        : text {
          value = "Tablet 4";
        }
        : text {
          value = "Screen";
        }
      }//end column
      : column {
        : text {
          value = "Cells";
        }
        : text {
          key = "COUNT1";
        }
        : text {
          key = "COUNT2";
        }
        : text {
          key = "COUNT3";
        }
        : text {
          key = "COUNT4";
        }
        : text {
          key = "COUNTS";        
          value = "1";
        }
      }//end column
      : column {
        : row {
          : text {
            value = "Upper Left";
          }
          : text {
            value = "Lower Right";
          }
          : text {
            value = "Import";
          }        
          }//end row
        : row {
          : edit_box {
            key = "Tablet1_ul";
          }
          : edit_box {
            key = "Tablet1_lr";
          }
          : toggle {
            key = "Import1";
          }          
        }//end row
        : row {
          : edit_box {
            key = "Tablet2_ul";
          }
          : edit_box {
            key = "Tablet2_lr";
          }
          : toggle {
            key = "Import2";
          }          
        }//end row
        : row {        
          : edit_box {
            key = "Tablet3_ul";
          }
          : edit_box {
            key = "Tablet3_lr";
          }
          : toggle {
            key = "Import3";
          }          
        }//end row
        : row {        
          : edit_box {
            key = "Tablet4_ul";
          }
          : edit_box {
            key = "Tablet4_lr";
          }
          : toggle {
            key = "Import4";
          }        
        }//end row
        : row {        
          : edit_box {
            key = "Screen_ul";
          }
          : edit_box {
            key = "Screen_lr";
          }
          : toggle {
            key = "ImportS";
            is_enabled = false;
            value = "1";
            //alignment = centered;
          }        
        }//end row        
      }//end column
    }//end row
  }//end column
  : column {
    : text {
      value = "Tablet Menu Layout:";
      alignment = centered;
    }
    : row {
      : spacer {
      }
      : text_part {
        value = "1";
      }
      : spacer {
        width = 24;
      }      
      : text_part {
        value = "26";
      }
    }
    : row {
      : column {
        : text_part {
          value = "A";
        }
        : text_part {
          value = "Z";
        }
      }
      : column {
        : image {
          key = "layout";
          width = 30;
          aspect_ratio = 1;
          color = 1;
          }
        }//end column
      }// row
    }//end column
  }//end row
  : spacer{
    height = 1;
  }
ok_cancel_help;
}

// tablet_modify.dcl
// Copyright (C) 1998 Visio Corporation.  All Rights Reserved.
//
// By Ronald Prepchuk

modify_tablet : dialog {
label = "Tablet Menu Modify";
initial_focus = "filename_b";
: row {
  : column {
    : text {
      value = "Tablet Menu Layout:";
      alignment = centered;
    }
    : row {
      : text_part {
        label = "Rows:";
      }    
      : text_part {
        value = "1";
      }
      : text_part {
        label = "          Columns:        ";
        width = 24;        
      }      
      : text_part {
        value = "26";
      }
    }
    : row {
      : column {
        : text_part {
          value = "     A";
          alignment = right;
        }
        : text_part {
          value = "     Z";
          alignment = right;          
        }
      }
      : column {
        : image_button {
          key = "layout";
          width = 40;
          aspect_ratio = 1;
          color = 1;
          }
        }//end column
      }// row
    }//end column
  }//end row
  : spacer{
    height = 1;
  }
  : text_part {
    label = "";
    key = "cell_num";
  }
  : edit_box {
    label = "Cell contents:";
    key = "cell";
    edit_limit = 255;
    edit_width = 40;
  }
  : column {
    : row {
        fixed_width = true;
        alignment = centered;
    : button {
      label = "Done";
      key = "accept";
      is_default = true;
      is_cancel = true;
      fixed_width = true;
      mnemonic = "D";
    }
        : spacer { width = 2; }
        help_button;
    }
  } 
}


// button_modify.dcl
// Copyright (C) 1998 Visio Corporation.  All Rights Reserved.
//
// By Ronald Prepchuk


modify_button : dialog {
label = "Modify Puck Buttons";
typeface = "Arial";
  : row {
    : radio_column {
      key = "picks";
      : radio_button {
        label = "Standard Pick";
        value = "1";
        key = "pick_st";
        mnemonic = "S";
      }
      : radio_button {
        label = "Shift Pick";
        key = "pick_sh";
        mnemonic = "S";
      }
      : radio_button {
        label = "Control Pick";
        key = "pick_co";
        mnemonic = "C";      
      }
      : radio_button {
        label = "Control+Shift Pick";
        key = "pick_cs";
        mnemonic = "C";
      }
    }//end radio_column
    : boxed_row {
      label = "Select button to modify:";
      : column {
        : button {
          label = "1";
          key = "pbutton1";
          }
        : button {
          label = "5";
          key = "pbutton5";
        }          
        : button {
          label = "9";
          key = "pbutton9";
        }
        : button {
          label = "13";
          key = "pbutton13";
        }        
      }// end column
      : column {
        : button {
          label = "2";
          key = "pbutton2";
        }
        : button {
          label = "6";
          key = "pbutton6";
        }
        : button {
          label = "10";
          key = "pbutton10";
        }
        : button {
          label = "14";
          key = "pbutton14";
        }        
      }// end row
      : column {
        : button {
          label = "3";
          key = "pbutton3";
        }
        : button {
          label = "7";
          key = "pbutton7";
        }
        : button {
          label = "11";
          key = "pbutton11";
        }
        : button {
          label = "15";
          key = "pbutton15";
        }        
      }// end row
      : column {
        : button {
          label = "4";
          key = "pbutton4";
        }
        : button {
          label = "8";
          key = "pbutton8";
        }
        : button {
          label = "12";
          key = "pbutton12";
        }        
        : button {
          label = "16";
          key = "pbutton16";
        }
      }// end row
    }//end column
  }//end row
  : text_part {
    label = "";
    key = "button_num";
  }
  : edit_box {
    label = "Button contents:";
    key = "button";
    edit_limit = 255;
    edit_width = 40;
  }
  : column {
    : row {
        fixed_width = true;
        alignment = centered;
    : button {
      label = "Done";
      key = "accept";
      is_default = true;
      is_cancel = true;
      fixed_width = true;
      mnemonic = "D";
    }
    : spacer { width = 2; }
    help_button;
    }
  }
}

